<?php
// Funkcja przetwarzajca cigi znakw w formacie CSV 
//  z moliwoci konfiguracji ogranicznikw i znaku do oznaczania cytatw.
function parse_csv($string, $delim = ',', $quote='"') {
    // Usunicie cudzysoww  w naszym algorytmie nie s potrzebne:
    $new = str_replace("{$quote}{$quote}", $quote, $string);
    
    // Pobranie wszystkich wartoci speniajcych warunki wyraenia regularnego.
    $matches = array();
    preg_match_all("/\s*({$quote}?)(.*?)\\1\s*(?:{$delim}|$)/", 
        $new, $matches);

    // Pasujce wartoci s zapisane jako element matches[2]. Zawsze wystpuje jedna warto nadmiarowa. 
    // Ostatni cig jest pusty. Usunicie go i zwrcenie wyniku:
    array_pop($matches[2]);
    return $matches[2];
}

$str = 'Przykad, "kilku ""wartoci""", oddzielonych   , "przecinkami.", "Cig, ktry zawiera przecinek i znak przejcia do\nnowego wiersza. " ';

// Rozbicie cigu na pojedyncze wartoci:
$values = parse_csv($str);

// Wywietlenie tablicy zwraca nastpujcy wynik:
// Array
// (
//     [0] => Przykad
//     [1] => kilku "wartoci"
//     [2] => oddzielonych
//     [3] => przecinkami.
//     [4] => Cig, ktry zawiera przecinek i znak przejcia do\nnowego wiersza. 
// )
echo '<pre>';
print_r($values);
echo '</pre>';
?>
